%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  FileName:            mfRxFrameSyn.m
%  Description:         ͨ4ʱ϶ǰ256chipsSSCأźʱ϶
%  Reference:           3GPP TS 25.211, 5.3.3.5 Synchronisation Channel (SCH)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  Parameter List:       
%       Output Parameter
%           search_flag     طǷ,0ʾδط壬1ʾط
%           group_No        ͬţҲ
%           timeslot_No     ݵһʱ϶ʱ϶  
%           rx_data         һ֡
%       Input Parameter
%           input_data      
%           sample_rate     
%           timeslot_star   ݵһʱ϶ʼĵ
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  History
%    1. Date:           2017-12-1
%       Author:         david.lee
%       Version:        1.0 
%       Modification:   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [search_flag, group_No, timeslot_No,rx_data] = CDMA_RxFrameSyn(input_data, sample_rate, timeslot_star)

%% ʼ
% Allocation of SSCs for secondary SCH
%           #0	#1	#2	#3	#4	#5	#6	#7	#8	#9	#10	#11	#12	#13	#14
% Group 0   1	1	2	8	9	10	15	8	10	16	2	7	15	7	16
% Group 1   1	1	5	16	7	3	14	16	3	10	5	12	14	12	10
% Group 2   1	2	1	15	5	5	12	16	6	11	2	16	11	15	12
% Group 3   1	2	3	1	8	6	5	2	5	8	4	4	6	3	7
% Group 4   1	2	16	6	6	11	15	5	12	1	15	12	16	11	2
% Group 5   1	3	4	7	4	1	5	5	3	6	2	8	7	6	8
% Group 6   1	4	11	3	4	10	9	2	11	2	10	12	12	9	3
% Group 7   1	5	6	6	14	9	10	2	13	9	2	5	14	1	13
% Group 8   1	6	10	10	4	11	7	13	16	11	13	6	4	1	16
% Group 9   1	6	13	2	14	2	6	5	5	13	10	9	1	14	10
% Group 10	1	7	8	5	7	2	4	3	8	3	2	6	6	4	5
% Group 11	1	7	10	9	16	7	9	15	1	8	16	8	15	2	2
% Group 12	1	8	12	9	9	4	13	16	5	1	13	5	12	4	8
% Group 13	1	8	14	10	14	1	15	15	8	5	11	4	10	5	4
% Group 14	1	9	2	15	15	16	10	7	8	1	10	8	2	16	9
% Group 15	1	9	15	6	16	2	13	14	10	11	7	4	5	12	3
% Group 16	1	10	9	11	15	7	6	4	16	5	2	12	13	3	14
% Group 17	1	11	14	4	13	2	9	10	12	16	8	5	3	15	6
% Group 18	1	12	12	13	14	7	2	8	14	2	1	13	11	8	11
% Group 19	1	12	15	5	4	14	3	16	7	8	6	2	10	11	13
% Group 20	1	15	4	3	7	6	10	13	12	5	14	16	8	2	11
% Group 21	1	16	3	12	11	9	13	5	8	2	14	7	4	10	15
% Group 22	2	2	5	10	16	11	3	10	11	8	5	13	3	13	8
% Group 23	2	2	12	3	15	5	8	3	5	14	12	9	8	9	14
% Group 24	2	3	6	16	12	16	3	13	13	6	7	9	2	12	7
% Group 25	2	3	8	2	9	15	14	3	14	9	5	5	15	8	12
% Group 26	2	4	7	9	5	4	9	11	2	14	5	14	11	16	16
% Group 27	2	4	13	12	12	7	15	10	5	2	15	5	13	7	4
% Group 28	2	5	9	9	3	12	8	14	15	12	14	5	3	2	15
% Group 29	2	5	11	7	2	11	9	4	16	7	16	9	14	14	4
% Group 30	2	6	2	13	3	3	12	9	7	16	6	9	16	13	12
% Group 31	2	6	9	7	7	16	13	3	12	2	13	12	9	16	6
% Group 32	2	7	12	15	2	12	4	10	13	15	13	4	5	5	10
% Group 33	2	7	14	16	5	9	2	9	16	11	11	5	7	4	14
% Group 34	2	8	5	12	5	2	14	14	8	15	3	9	12	15	9
% Group 35	2	9	13	4	2	13	8	11	6	4	6	8	15	15	11
% Group 36	2	10	3	2	13	16	8	10	8	13	11	11	16	3	5
% Group 37	2	11	15	3	11	6	14	10	15	10	6	7	7	14	3
% Group 38	2	16	4	5	16	14	7	11	4	11	14	9	9	7	5
% Group 39	3	3	4	6	11	12	13	6	12	14	4	5	13	5	14
% Group 40	3	3	6	5	16	9	15	5	9	10	6	4	15	4	10
% Group 41	3	4	5	14	4	6	12	13	5	13	6	11	11	12	14
% Group 42	3	4	9	16	10	4	16	15	3	5	10	5	15	6	6
% Group 43	3	4	16	10	5	10	4	9	9	16	15	6	3	5	15
% Group 44	3	5	12	11	14	5	11	13	3	6	14	6	13	4	4
% Group 45	3	6	4	10	6	5	9	15	4	15	5	16	16	9	10
% Group 46	3	7	8	8	16	11	12	4	15	11	4	7	16	3	15
% Group 47	3	7	16	11	4	15	3	15	11	12	12	4	7	8	16
% Group 48	3	8	7	15	4	8	15	12	3	16	4	16	12	11	11
% Group 49	3	8	15	4	16	4	8	7	7	15	12	11	3	16	12
% Group 50	3	10	10	15	16	5	4	6	16	4	3	15	9	6	9
% Group 51	3	13	11	5	4	12	4	11	6	6	5	3	14	13	12
% Group 52	3	14	7	9	14	10	13	8	7	8	10	4	4	13	9
% Group 53	5	5	8	14	16	13	6	14	13	7	8	15	6	15	7
% Group 54	5	6	11	7	10	8	5	8	7	12	12	10	6	9	11
% Group 55	5	6	13	8	13	5	7	7	6	16	14	15	8	16	15
% Group 56	5	7	9	10	7	11	6	12	9	12	11	8	8	6	10
% Group 57	5	9	6	8	10	9	8	12	5	11	10	11	12	7	7
% Group 58	5	10	10	12	8	11	9	7	8	9	5	12	6	7	6
% Group 59	5	10	12	6	5	12	8	9	7	6	7	8	11	11	9
% Group 60	5	13	15	15	14	8	6	7	16	8	7	13	14	5	16
% Group 61	9	10	13	10	11	15	15	9	16	12	14	13	16	14	11
% Group 62	9	11	12	15	12	9	13	13	11	14	10	16	15	14	16
% Group 63	9	12	10	15	13	14	9	14	15	11	11	13	12	16	10
Group=[ 
    1     1     2     8     9    10    1     1     2      8     9    10    
    1     1     5    16     7     3    1     1     5     16     7     3    
    1     2     1    15     5     5    1     2     1     15     5     5    
    1     2     3     1     8     6    1     2     3      1     8     6    
    1     2    16     6     6    11    1     2    16      6     6    11    
    1     3     4     7     4     1    1     3     4      7     4     1    
    1     4    11     3     4    10    1     4    11      3     4    10    
    1     5     6     6    14     9    1     5     6      6    14     9    
    1     6    10    10     4    11    1     6    10     10     4    11    
    1     6    13     2    14     2    1     6    13      2    14     2    
    1     7     8     5     7     2    1     7     8      5     7     2    
    1     7    10     9    16     7    1     7    10      9    16     7    
    1     8    12     9     9     4    1     8    12      9     9     4    
    1     8    14    10    14     1    1     8    14     10    14     1    
    1     9     2    15    15    16    1     9     2     15    15    16    
    1     9    15     6    16     2    1     9    15      6    16     2    
    1    10     9    11    15     7    1    10     9     11    15     7    
    1    11    14     4    13     2    1    11    14      4    13     2    
    1    12    12    13    14     7    1    12    12     13    14     7    
    1    12    15     5     4    14    1    12    15      5     4    14    
    1    15     4     3     7     6    1    15     4      3     7     6    
    1    16     3    12    11     9    1    16     3     12    11     9    
    2     2     5    10    16    11    2     2     5     10    16    11    
    2     2    12     3    15     5    2     2    12      3    15     5    
    2     3     6    16    12    16    2     3     6     16    12    16    
    2     3     8     2     9    15    2     3     8      2     9    15    
    2     4     7     9     5     4    2     4     7      9     5     4    
    2     4    13    12    12     7    2     4    13     12    12     7    
    2     5     9     9     3    12    2     5     9      9     3    12    
    2     5    11     7     2    11    2     5    11      7     2    11    
    2     6     2    13     3     3    2     6     2     13     3     3    
    2     6     9     7     7    16    2     6     9      7     7    16    
    2     7    12    15     2    12    2     7    12     15     2    12    
    2     7    14    16     5     9    2     7    14     16     5     9    
    2     8     5    12     5     2    2     8     5     12     5     2    
    2     9    13     4     2    13    2     9    13      4     2    13    
    2    10     3     2    13    16    2    10     3      2    13    16    
    2    11    15     3    11     6    2    11    15      3    11     6    
    2    16     4     5    16    14    2    16     4      5    16    14    
    3     3     4     6    11    12    3     3     4      6    11    12    
    3     3     6     5    16     9    3     3     6      5    16     9    
    3     4     5    14     4     6    3     4     5     14     4     6    
    3     4     9    16    10     4    3     4     9     16    10     4    
    3     4    16    10     5    10    3     4    16     10     5    10    
    3     5    12    11    14     5    3     5    12     11    14     5    
    3     6     4    10     6     5    3     6     4     10     6     5    
    3     7     8     8    16    11    3     7     8      8    16    11    
    3     7    16    11     4    15    3     7    16     11     4    15    
    3     8     7    15     4     8    3     8     7     15     4     8    
    3     8    15     4    16     4    3     8    15      4    16     4    
    3    10    10    15    16     5    3    10    10     15    16     5    
    3    13    11     5     4    12    3    13    11      5     4    12    
    3    14     7     9    14    10    3    14     7      9    14    10    
    5     5     8    14    16    13    5     5     8     14    16    13    
    5     6    11     7    10     8    5     6    11      7    10     8    
    5     6    13     8    13     5    5     6    13      8    13     5    
    5     7     9    10     7    11    5     7     9     10     7    11    
    5     9     6     8    10     9    5     9     6      8    10     9    
    5    10    10    12     8    11    5    10    10     12     8    11    
    5    10    12     6     5    12    5    10    12      6     5    12    
    5    13    15    15    14     8    5    13    15     15    14     8    
    9    10    13    10    11    15    9    10    13     10    11    15    
    9    11    12    15    12     9    9    11    12     15    12     9    
    9    12    10    15    13    14    9    12    10     15    13    14    
];

group_No=0;

%% ʵ
%ɸͬ
%z sequence
x = [1, 1, 1, 1, 1, 1, -1, -1, 1, -1, 1, -1, 1, -1, -1, 1];
b = [x(1), x(2), x(3), x(4), x(5), x(6), x(7), x(8), -x(9), -x(10), -x(11), -x(12), -x(1), -x(13), -x(14), -x(15)];
z = [b, b, b, -b, b, b, -b, -b, b, -b, b, -b, -b, -b, -b, -b];
%Hadamard sequences
H0=1;
H1=[H0,H0;H0,-H0];
H2=[H1,H1;H1,-H1];
H3=[H2,H2;H2,-H2];
H4=[H3,H3;H3,-H3];
H5=[H4,H4;H4,-H4];
H6=[H5,H5;H5,-H5];
H7=[H6,H6;H6,-H6];
H8=[H7,H7;H7,-H7];
m=[0,16,32,48,64,80,96,112,128,144,160,176,192,208,224,240];
h=zeros(16,256);
for n=1:16
    h(n,1:256)=H8(m(n)+1,1:256);
end   
%Secondary Synchronization Codes
SSC=zeros(16,256);
for n=1:16
    SSC(n,1:256)=(1+1i)*z.*h(n,1:256);
end
SSC_sample=zeros(16,256*sample_rate);
for n=1:16
    for code_num=1:256
        for sample_num=1:sample_rate
            SSC_sample(n,(code_num-1)*sample_rate+sample_num)=SSC(n,code_num);
        end
    end
end

%ͬ
timeslot_num=2560*sample_rate;
SCH_num=256*sample_rate;
SSC_No=zeros(1,8);
for num=1:6
    star=timeslot_star+(num-1)*timeslot_num;
    Rx_data=input_data(star:star+SCH_num-1);
    SSC_correlation=zeros(1,16);
    for SSC_num=1:16
        for n=1:SCH_num
            SSC_correlation(SSC_num)=SSC_correlation(SSC_num)+Rx_data(n)*SSC_sample(SSC_num,n);
        end
    end
    mod_SSC_corr=abs(SSC_correlation);
    SSC_No(num)=find(max(mod_SSC_corr)==mod_SSC_corr);
end

%ֵȷϸͬżһʱ϶ʱ϶
for m=1:64
    for n=0:5
        max_val=0;
        for nn=1:6
            if SSC_No(nn)==Group(m,n+nn)
                max_val=max_val+1;
                if max_val>5    %6ʱ϶5ͬһ¼Ϊҵ֡ͬ
                    group_No=m;
                    timeslot_No=n+1;
                    search_flag=1; 
                    break;
                end
            end
        end
    end
end
if group_No==0 
    search_flag=0;
    timeslot_No=0;
else
    search_flag=1;
end

firstTimeslotNo=timeslot_No;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%һͬʱ϶֡еʱ϶Ϊ1ʱ϶ͷҲ֡ͷ
if firstTimeslotNo == 1
    frameStart = timeslot_star;
else
    %򣬸֡еʱ϶Žλȡһ֡
    frameStart = 2560*sample_rate*(6-(firstTimeslotNo-1)) + timeslot_star;
end

rx_data = input_data(1, frameStart: frameStart+2560*6*sample_rate-1);